//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-11: Balances on Transient Processes
//Example: 11.4-1 Page 560
//Title: Transient Balances on a Semibatch Reactor
//===================================================================
model Ex11_4_1
    //=============
    //Set simulation time greater than 50
    // Parameter Section
    parameter Real CA_i (unit ="mol A/ L") = 0.015 "Feed concentration of A";
    parameter Real V0 (unit = "L") = 75 "Initial volume of fluid in reactor";
    
    //=============
    // Variable Section
    Real vdot (unit = "L/s") "Feed flow rate";
    Real CA (unit = "mol A/L", start = 0) "Concentration of A in reactor";
    Real V (unit = "L", start = V0) "Volume of fluid in reactor";
            
    //=============
    // Equation Section 
    equation
        if time < 10 then
            vdot = 2.5 * time;
        else
            vdot = 25;
        end if;
        der(V) = vdot;
        der(CA) = vdot / V * (CA_i - CA) - 0.0375*CA;
                         
end Ex11_4_1;
//===================================================================