//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000

//Chapter-2: Introduction to Engineering Calculations
//Example: 2.2-1 Page 10
//Title: Conversion of Units
//===================================================================
model Ex2_2_1
//=============
// Parameter Section 
parameter Real accl (unit="cm/s^2")= 1 "Acceleration in given units";

//=============
// Variable Section 
Real conv_accl (unit="km/yr^2") "Converted acceleration in required units";

//=============
// Equation  Section 
equation
   conv_accl = accl*(3600^2)*(24^2)*(365^2)/(10^2)/(10^3);
   //3600 s = 1 hr, 24 hr = 1 day, 365 days = 1 yr, 1 m = 10^2 cm, 1 km = 10^3 m

end Ex2_2_1;
//===================================================================