//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc.
//Chapter-2: Introduction to Engineering Calculations
//Example: 2.3-1 Page 11
//Title: Conversion Between Systems of Units
//===================================================================
model Ex2_3_1
    //=============
    // Parameter Section 
    parameter Real force (unit="lbft/min^2")= 23 "Quantity in given units";
    
    //=============
    // Variable Section 
    Real conv_force (unit="kgcm/s^2") "Converted quantity in required units";
    
    //=============
    // Equation  Section 
    equation
       conv_force= force*0.453593*100/3.281/(60^2);
       //Since, 1 lb = 0.453593 kg, 100 cm = 3.821 ft, 1 min = 60 s

end Ex2_3_1;
//===================================================================