//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-2: Introduction to Engineering Calculations
//Example: 2.4-1 Page 13
//Title: Weight and Mass
//===================================================================
model Ex2_4_1 
    //=============
    // Parameter Section
    parameter Real density(unit = "lb/ft^3") = 62.4 "Density of water";
    parameter Real volume(unit = "ft^3") = 2 "Volume of water";
    parameter Real g_sl(unit = "ft/s^2") = 32.174 "Acceleration due to gravity at sea level";
    parameter Real g_d(unit = "ft/s^2") = 32.139 "Acceleration due to gravity at Denver";
    
    //=============
    // Variable Section
    Real M(unit = "lb") "Mass of given volume of water";
    Real W_sl(unit = "lbf") "Weight of given volume of water at sea level";
    Real W_d(unit = "lbf") "Weight of given volume of water at Denver";
    
    //=============
    // Equation  Section
    equation
      M = density * volume;
      W_sl = M * g_sl / 32.174;
      W_d = M * g_d / 32.174;
      
end Ex2_4_1;
//===================================================================