//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000

//Chapter-3: Processes and Process Variables
//Example: 3.3-1 Page 48
//Title: Conversion between mass and moles
//===================================================================
package Ex3_3_1
    
    model Ex3_3_1_1
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        
        //=============
        // Variable Section 
        Real moles (unit="mol") "Moles of CO2 present";
        
        //=============
        // Equation  Section 
        equation
           moles=m/M;
        
    end Ex3_3_1_1;
    //===================================================================
    
    model Ex3_3_1_2
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        
        //=============
        // Variable Section
        Real moles (unit="mol") "Moles of CO2 present";
        Real lb_moles (unit="mol") "Moles of CO2 present";
        
        //=============
        // Equation  Section 
        equation
          moles=m/M;
          lb_moles=moles/453.6;
          
    end Ex3_3_1_2;
    //===================================================================
    
    model Ex3_3_1_3
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        
        //=============
        // Variable Section
        Real moles (unit="mol") "Moles of CO2 present";
        Real moles_C (unit="mol") "Moles of C present";
        
        //=============
        // Equation  Section 
        equation
          moles=m/M;
          moles_C=moles;
          
    end Ex3_3_1_3;
    //===================================================================
    
    model Ex3_3_1_4
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        
        //=============
        // Variable Section
        Real moles (unit="mol") "Moles of CO2 present";
        Real moles_O (unit="mol") "Moles of O present";
        
        //=============
        // Equation  Section 
        equation
          moles=m/M;
          moles*2=moles_O;
          
    end Ex3_3_1_4;
    //===================================================================
    
    model Ex3_3_1_5
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        
        //=============
        // Variable Section
        Real moles (unit="mol") "Moles of CO2 present";
        Real moles_O2 (unit="mol") "Moles of O2 present";
        
        //=============
        // Equation  Section 
        equation
          moles=m/M;
          moles_O2 =moles;
          
    end Ex3_3_1_5;
    //===================================================================
    
    model Ex3_3_1_6
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        
        //=============
        // Variable Section
        Real moles (unit="mol") "Moles of CO2 present";
        Real moles_O (unit="mol") "Moles of O present";
        Real mass_O (unit="g") "Mass of O present";
        
        //=============
        // Equation  Section 
        equation
          moles=m/M;
          moles_O=2*moles;
          mass_O=moles_O * 16; //Molar mass of atomic oxygen is 16 g/mol
          
    end Ex3_3_1_6;
    //===================================================================
    
    model Ex3_3_1_7
    //=============
    // Parameter Section 
    parameter Real m (unit="g") = 100 "Mass of CO2";
    parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
    
    //=============
    // Variable Section
    Real moles (unit="mol") "Moles of CO2 present";
    Real moles_O2 (unit="mol") "Moles of O2 present";
    Real mass_O2 (unit="g") "Mass of O2 present";
    
    //=============
    // Equation  Section 
    equation
      moles=m/M;
      moles_O2=moles;
      mass_O2 = moles_O2 * 32; //Molar mass of O2 is 32 g/mol
      
    end Ex3_3_1_7;
    //===================================================================
    
    model Ex3_3_1_8
        //=============
        // Parameter Section 
        parameter Real m (unit="g") = 100 "Mass of CO2";
        parameter Real M (unit="g/mol") = 44.01 "Molar mass of CO2";
        parameter Real NA (unit = "1/mol") = 6.022e23 "Avogadro's constant";
        
        //=============
        // Variable Section
        Real moles (unit="mol") "Moles of CO2 present";
        Real molecules "Number of molecules present";
        
        //=============
        // Equation  Section 
        equation
          moles=m/M;
          molecules = moles * NA;
          
    end Ex3_3_1_8;
    //===================================================================

end Ex3_3_1;
//===================================================================
