//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-3: Processes and Process Variables
//Example: 3.4-2 Page 55
//Title: Pressure below the surface of a fluid
//===================================================================
model Ex3_4_2
    //=============
    // Parameter Section 
    parameter Real P_0 (unit = "m H2O") = 10.4 "Atmospheric pressure head";
    parameter Real h (unit = "m") = 30 "Depth of water";
    parameter Real g (unit = "N/kg") = 9.807 "Acceleration due to gravity";
    parameter Real ro (unit= "kg/m^3") = 1000 "Density of H2O";
    
    //=============
    // Variable Section 
    Real P_h (unit = "Pa") "Pressure at 30 m depth in the lake";
    
    //=============
    // Equation  Section 
    equation
        P_h = (P_0 * 1.013e5 / 10.33) + (ro* g* h); //Conversion factor is 1.013e5 Pa = 10.33 m H2O
      
end Ex3_4_2;