//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.3-1 Page 92
//Title: Flowchart of an Air Humidification and Oxygenation Process
//===================================================================
//Variable air1.p._dot corresponds to n1_dot in text
//water1.p.n_dot = n2_dot
//out1.p.n_dot = n3_dot
//out1.p.xO2 = y
package Ex4_3_1
  connector port
  //=============
	// Variable Section 
    Real n_dot(unit = "mol / min") "Molar flow rate of the stream";
    Real x_O2 "Mole fraction of O2 in the stream";
    Real x_H2O "Mole fraction of H2O in the stream";
    Real x_N2 "Mole fraction of N2 in the stream";
    annotation(Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(fillColor = {85, 170, 127}, fillPattern = FillPattern.Solid, extent = {{-100, 100}, {100, -100}})}));
  end port;
//===================================================================
	class water
    //This class denotes the water stream
    //=============
		// Parameter Section 
    parameter Real v_dot(unit = "cm^3 / min") = 20 "Volumetric flow rate of water feed";
  	port p annotation(Placement(visible = true, transformation(origin = {2, 2}, extent = {{-50, -50}, {50, 50}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
  //=============
	// Equation  Section 
	equation
    p.n_dot = v_dot * 1 / 18.02;
		//Conversion of volumetric flow to molar flow
    p.x_O2 = 0;
    p.x_H2O = 1;
    p.x_N2 = 0;
  end water;
//===================================================================
  class air
    //This class denotes the water stream
    port p annotation(Placement(visible = true, transformation(origin = {36, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
//=============
// Equation  Section 
  equation
    p.x_O2 = 0.21;
    p.x_N2 = 0.79;
    p.x_H2O = 0;
  end air;
//===================================================================
  class oxygen
    //This class denotes the water stream
    port p annotation(Placement(visible = true, transformation(origin = {36, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
//=============
// Equation  Section 
	equation
    p.x_O2 = 1;
    p.x_N2 = 0;
    p.x_H2O = 0;    
  end oxygen;
//===================================================================
  class out
    //This class denotes the output stream
    port p annotation(Placement(visible = true, transformation(origin = {36, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
//=============
// Equation  Section 
  equation
    p.x_H2O = 0.015;
  end out;
//===================================================================
  class chamber
    //This class represents the evaporation chamber
    Ex4_3_1.port ip_water annotation(Placement(visible = true, transformation(origin = {-59, 59}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {-60, 58}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
    Ex4_3_1.port ip_air annotation(Placement(visible = true, transformation(origin = {-60, 0}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {-60, 1.16248e-15}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
    Ex4_3_1.port ip_ox annotation(Placement(visible = true, transformation(origin = {-60, -60}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {-60, -60}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
    Ex4_3_1.port op annotation(Placement(visible = true, transformation(origin = {62, 0}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {60, 2.22045e-16}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
//=============
// Equation  Section 
  equation
    ip_ox.n_dot = ip_air.n_dot / 5; //Given that molar flow rate of oxygen is a fifth of air molar rate
    ip_ox.n_dot + ip_air.n_dot + ip_water.n_dot = op.n_dot; //Overall mass balance
    ip_ox.n_dot + ip_air.n_dot * ip_air.x_O2 = op.x_O2 * op.n_dot; //Oxygen balance
    ip_air.n_dot * ip_air.x_N2 = op.x_N2 * op.n_dot; //Nitrogen balance
    ip_water.n_dot = op.x_H2O * op.n_dot; //Water balance
     
    annotation(Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, extent = {{-100, 100}, {100, -100}}), Text(origin = {-47, 83}, extent = {{-33, 17}, {9, -7}}, textString = "Water port"), Text(origin = {-62, 32}, extent = {{-12, 6}, {16, -12}}, textString = "Air port"), Text(origin = {-57, -32}, extent = {{-17, 8}, {13, -6}}, textString = "O2 Port"), Text(origin = {52, 30}, extent = {{-10, 8}, {30, -20}}, textString = "Output port")}), Diagram(coordinateSystem(initialScale = 0.1)));
  end chamber;
//===================================================================
  class process
    Ex4_3_1.chamber chamber1 annotation(Placement(visible = true, transformation(origin = {-1, 1}, extent = {{-41, -41}, {41, 41}}, rotation = 0)));
    water water1 annotation(Placement(visible = true, transformation(origin = {-80, 46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Ex4_3_1.air air1 annotation(Placement(visible = true, transformation(origin = {-80, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Ex4_3_1.out out1 annotation(Placement(visible = true, transformation(origin = {82, -4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Ex4_3_1.oxygen oxygen1 annotation(Placement(visible = true, transformation(origin = {-80, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
//=============
// Equation  Section 
  equation
  connect(chamber1.ip_ox, oxygen1.p) annotation(Line(points = {{-26, -24}, {-51, -24}, {-51, -46}, {-80, -46}}));
  connect(chamber1.op, out1.p) annotation(Line(points = {{24, 1}, {59, 1}, {59, -4}, {82, -4}}));
  connect(water1.p, chamber1.ip_water) annotation(Line(points = {{-80, 46}, {-60, 46}, {-60, 25}, {-26, 25}}));
  connect(chamber1.ip_air, air1.p) annotation(Line(points = {{-26, 1}, {-48, 1}, {-48, -6}, {-80, -6}}));
  end process;
//===================================================================
end Ex4_3_1;