//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.3-2 Page 94
//Title: Scale up of a Separation Process Flowchart
//===================================================================
model Ex4_3_2
		//=============
		// Parameter Section 
		parameter Real feed_ndot1 (unit="mol") = 100 "Feed molar flow rate in 1st flow chart";
		parameter Real feed_xA1 = 0.6 "Feed mole fraction of A in 1st flow chart";
		parameter Real feed_xB1 = 0.4 "Feed mole fraction of B in 1st flow chart";
		parameter Real top_ndot1 (unit="mol") = 50 "Top product molar flow rate in 1st flow chart";
		parameter Real top_xA1 = 0.95 "Top product mole fraction of A in 1st flow chart";
		parameter Real top_xB1 = 0.05 "Top product mole fraction of B in 1st flow chart";
		parameter Real bot_ndot1 (unit="mol") = 50 "Bottom product molar flow rate in 1st flow chart"; //There is a mistake in the textbook, this value must be 50 for mole balance to be satisfied
		parameter Real bot_nA1 = 12.5 "Bottom product moles of A in 1st flow chart";
		parameter Real bot_nB1 = 37.5 "Bottom product moles of B in 1st flow chart";
		parameter Real feed_ndot2 (unit="lb mol/h") = 1250 "Feed molar flow rate in scaled up flow chart";
		//=============
		// Variable Section 		
		Real feed_xA2 "Feed mole fraction of A in 2nd flow chart";
		Real feed_xB2 "Feed mole fraction of B in 2nd flow chart";
		Real top_ndot2 (unit="mol") "Top product molar flow rate in 2nd flow chart";
		Real top_xA2 "Top product mole fraction of A in 2nd flow chart";
		Real top_xB2 "Top product mole fraction of B in 2nd flow chart";
		Real bot_ndot2 (unit="mol") "Bottom product molar flow rate in 2nd flow chart";
		Real bot_nA2 "Bottom product moles of A in 2nd flow chart";
		Real bot_nB2 "Bottom product moles of B in 2nd flow chart";
		Real scale_factor (unit = "lb mole/ h mole") "Scale factor for the scale up";
		//=============
		// Equation Section 
		equation
				scale_factor = feed_ndot2 / feed_ndot1;
				feed_xA2 = feed_xA1;
				feed_xB2 = feed_xB1;
				top_xA2 = top_xA1;
				top_xB2 = top_xB1;
				top_ndot2 = top_ndot1 * scale_factor;
				bot_ndot2 = bot_ndot1 * scale_factor;
				bot_nA2 = bot_nA1 * scale_factor;
				bot_nB2 = bot_nB1 * scale_factor;
//===================================================================
end Ex4_3_2;