//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.3-3 Page 97
//Title: Balances on a Mixing Unit
//===================================================================
//water1.p.m = m1
//mixing1.op.V = V1
//out.p.m = m2
package Ex4_3_3
          
  connector port
    //=============
    // Variable Section
    Real m(unit = "kg") "Mass flow rate of the stream";
    Real x_H2O(unit = "kg H2O / kg") "Mass fraction of H2O in the stream";
    Real x_NaOH(unit = "kg NaOH / kg") "Mass fraction of NaOH in the stream";
    annotation(Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(fillColor = {85, 170, 127}, fillPattern = FillPattern.Solid, extent = {{-100, 100}, {100, -100}})}));
  end port;

  //===================================================================

  class water
    //This class denotes the water stream
    port p annotation(Placement(visible = true, transformation(origin = {2, 2}, extent = {{-50, -50}, {50, 50}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
    //=============
    // Equation  Section
  equation
    p.x_H2O = 1;
    p.x_NaOH = 0;
  end water;

  //===================================================================

  class NaOH20
    //This class denotes the feed stream with 20% NaOH
    port p annotation(Placement(visible = true, transformation(origin = {36, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
    //=============
    // Equation  Section
  equation
    p.m = 100;
//Assuming 100 kg basis
    p.x_NaOH = 0.20;
    p.x_H2O = 0.80;
  end NaOH20;

  //===================================================================

  class out
    //This class denotes the output stream
    port p annotation(Placement(visible = true, transformation(origin = {36, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -4}, extent = {{-34, -34}, {34, 34}}, rotation = 0)));
    //=============
    // Equation  Section
  equation
    p.x_H2O = 0.92;
    p.x_NaOH = 0.08;
  end out;

  //===================================================================

  class mixing
    //This class represents the mixing chamber
    Ex4_3_3.port H2O annotation(Placement(visible = true, transformation(origin = {-59, 59}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {-50, 56}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
    Ex4_3_3.port NaOH annotation(Placement(visible = true, transformation(origin = {-60, 0}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {-50, -40}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
    Ex4_3_3.port op annotation(Placement(visible = true, transformation(origin = {62, 0}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {60, 2.22045e-16}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
    parameter Real ro_water(unit = "kg/l") = 1 "Density of water";
    //=============
    // Variable Section
    Real v1(unit = "liters") "Volume of water to be fed";
    Real water_per_feed(unit = "liter H2O / kg feed solution");
    Real product_per_feed(unit = "kg product solution / kg feed solution");
    //=============
    // Equation  Section
  equation
    NaOH.m + H2O.m = op.m;
//Overall mass balance;
    NaOH.x_NaOH * NaOH.m + H2O.x_NaOH * H2O.m = op.x_NaOH * op.m;
//NaOH balance;
    v1 = H2O.m / ro_water;
    water_per_feed = v1 / NaOH.m;
    product_per_feed = op.m / NaOH.m;
    annotation(Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, extent = {{-100, 100}, {100, -100}}), Text(origin = {-37, 81}, extent = {{-33, 17}, {9, -7}}, textString = "Water port"), Text(origin = {-62, -2}, extent = {{-12, 6}, {36, -28}}, textString = "20% NaOH port"), Text(origin = {52, 30}, extent = {{-10, 8}, {30, -20}}, textString = "Output port")}), Diagram(coordinateSystem(initialScale = 0.1)));
  end mixing;

  //===================================================================

  class process
    //=============
    // Variable Section
    mixing mixing1 annotation(Placement(visible = true, transformation(origin = {-1, 1}, extent = {{-37, -37}, {37, 37}}, rotation = 0)));
    water water1 annotation(Placement(visible = true, transformation(origin = {-78, 22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    NaOH20 naOH201 annotation(Placement(visible = true, transformation(origin = {-78, -14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    out out1 annotation(Placement(visible = true, transformation(origin = {76, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    //=============
    // Equation  Section
  equation
    connect(mixing1.op, out1.p) annotation(Line(points = {{22, 2}, {76, 2}, {76, 0}, {76, 0}}));
    connect(mixing1.NaOH, naOH201.p) annotation(Line(points = {{-20, -14}, {-78, -14}, {-78, -14}, {-78, -14}}));
    connect(mixing1.H2O, water1.p) annotation(Line(points = {{-20, 22}, {-78, 22}, {-78, 22}, {-78, 22}}));
  end process;

  //===================================================================
end Ex4_3_3;