//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.4-1 Page 105
//Title: Two Unit Processes
//===================================================================
model Ex4_4_1
    //=============
    // Parameter Section
    parameter Real m_f (unit = "kg /h") = 100 "Feed mass flow rate";
    parameter Real x_f (unit = "kg A/ kg") = 0.5 "Mass fraction of A in feed";
    parameter Real m_o1 (unit = "kg /h") = 40 "Mass flow rate of side output stream of unit 1";
    parameter Real x_o1 (unit = "kg A/ kg") = 0.9 "Mass fraction of A in side output stream of unit 1";
    parameter Real m_o2 (unit = "kg /h") = 30 "Mass flow rate of side output stream of unit 2";
    parameter Real x_o2 (unit = "kg A/ kg") = 0.6 "Mass fraction of A in side output stream of unit 2";
    parameter Real m_m (unit = "kg /h") = 30 "Mass flow rate of inlet at mixing point";
    parameter Real x_m (unit = "kg A/ kg") = 0.3 "Mass fraction of A in inlet at mixing point";
    //=============
    // Variable Section 		
    Real m1 (unit = "kg /h") "Mass flow rate of output of unit 1";
    Real x1 (unit = "kg A/ kg") "Mass fraction of A in output from unit 1";
    Real m2 (unit = "kg /h") "Mass flow rate after mixing point";
    Real x2 (unit = "kg A/ kg") "Mass fraction of A after mixing point";
    Real m3 (unit = "kg /h") "Mass flow rate at final output";
    Real x3 (unit = "kg A/ kg") "Mass fraction of A at final output";
    
    //=============
    // Equation Section 
    equation
        m_f + m_m = m3 + m_o1 +m_o2; //Overall mass balance
        m_f*x_f + m_m*x_m = m3*x3 + m_o1*x_o1 + m_o2*x_o2; //Overall balance of A
        m_f = m_o1 + m1; //Mass balance for unit 1
        m_f*x_f = m_o1*x_o1 + m1*x1; //Balance for A over unit 1
        m1 + m_m = m2; //Mass balance over mixing point
        m1*x1 + m_m*x_m = m2*x2; //Balance for A across mixing point    
end Ex4_4_1;
//===================================================================