//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.8-3 Page 147
//Title: Combustion of Ethane
//===================================================================
model Ex4_8_3
    //=============
    // Parameter Section
    parameter Real nf (unit = "mol") = 100 "Moles of ethane fed";
    parameter Real fC2H6 = 0.9 "Fractional conversion of ethane";
      
    //=============
    // Variable Section 		
    Real nO2_theoretical (unit = "mol air") "Theoretical O2 requirement";
    Real n0 (unit = "mol air") "Moles of air fed";
    Real n1 (unit = "mol C2H6") "Moles of ethane unburnt";
    Real n2 (unit = "mol O2") "Moles of O2 in effluent";
    Real n3 (unit = "mol N2") "Moles of N2 in stack gas";
    Real n5 (unit = "mol CO2") "Moles of CO2 in stack gas";
    Real n6 (unit = "mol H2O") "Moles of H2O in stack gas";
    Real n4 (unit = "mol CO") "Moles of CO in stack gas";    
    Real mr_H2O (unit = "mol H2O / mol dry gas") "Mole ratio of water in stack gas";
    Real y1 (unit = "mol C2H6 /mol dry gas") "Mole fraction of ethane in stack gas";
    Real y2 (unit = "mol O2 /mol dry gas") "Mole fraction of O2 in stack gas";
    Real y3 (unit = "mol N2 /mol dry gas") "Mole fraction of N2 in stack gas";
    Real y4 (unit = "mol CO /mol dry gas") "Mole fraction of CO in stack gas";
    Real y5 (unit = "mol CO2 /mol dry gas") "Mole fraction of CO2 in stack gas";
    
    //=============
    // Equation Section 
    equation
        nO2_theoretical = nf * 3.5;
        n0 = nO2_theoretical/ 0.21 * 150 / 100; //50% excess
        n1 = nf * (1 - fC2H6);
        n4 = 0.25 * nf * fC2H6 * 2; //25% conversion of C2H6 to CO
        n3 = 0.79 * n0; //N2 balance
        nf * 2 = n1 * 2 + n4 * 1 + n5 * 1; //C atom balance
        nf * 6 = n1 * 6 + n6 * 2; //H atom balance
        n0 * 0.21 * 2 = n2 * 2 + n4 * 1 + n5 * 2 + n6 * 1; //O atom balance
        mr_H2O = n6 / (n1 + n2 + n3 + n4 + n5);
        y1 = n1 / (n1 + n2 + n3 + n4 + n5);
        y2 = n2 / (n1 + n2 + n3 + n4 + n5);
        y3 = n3 / (n1 + n2 + n3 + n4 + n5);
        y4 = n4 / (n1 + n2 + n3 + n4 + n5);
        y5 = n5 / (n1 + n2 + n3 + n4 + n5);        
        
end Ex4_8_3 ;
//===================================================================