//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.8-4 Page 149
//Title: Combustion of Hydrocarbon Fuel of Unknown Composition
//===================================================================
model Ex4_8_4
    //=============
    // Parameter Section
    parameter Real yCO (unit = "mol CO/ mol dry gas") = 0.015 "Mole fraction of CO";
    parameter Real yCO2 (unit = "mol CO2/ mol dry gas") = 0.060 "Mole fraction of CO2";
    parameter Real yO2 (unit = "mol O2/ mol dry gas") = 0.082 "Mole fraction of O2";
    parameter Real yN2 (unit = "mol N2/ mol dry gas") = 0.843 "Mole fraction of N2";
    
          
    //=============
    // Variable Section 	
    Real excess (unit = "%") "Percentage excess of air";
    Real nO2_th (unit = "mol/h") "Theoretical oxygen requirement";
    Real nC (unit = "mol C") "Moles of carbon in feed";
    Real nH (unit = "mol H") "Moles of hydrogen in feed";
    Real na (unit = "mol air")"Moles of air fed";
    Real CHratio (unit = "mol C/ mol H") "carbon hydrogen ratio";       
    Real nw (unit = "mol H2O") "Moles of water produced";
    
    //=============
    // Equation Section 
    equation
        0.79 * na = 100 * yN2; //N2 balance
        nC = 100 * (yCO2 + yCO); //C balance
        nH = nw * 2; //H balance
        0.21 * na * 2 = nw + 100 * (yCO + yCO2 * 2 + yO2 * 2); //O balance
        CHratio = nH / nC;
        nO2_th = nC + nH / 4;
        excess = ((na * 0.21) - nO2_th) / nO2_th * 100;
    
end Ex4_8_4 ;
//===================================================================