//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.2-1 Page 192
//Title: The Ideal Gas Equation of State
//===================================================================
model Ex5_2_1
    //=============
    // Parameter Section
    parameter Real m (unit="g") = 100 "Mass of nitrogen stored";
    parameter Real T_c (unit="degC") = 23 "Temperature of the nitrogen in celsius";
    parameter Real P_g (unit="psig") = 3 "Gauge pressure of the nitrogen";
    parameter Real M (unit="g/mol") =28 "Molar mass of nitrogen";
    parameter Real R (unit="Latm/molK") = 0.08206 "Gas constant";
    parameter Real P_atm (unit="psi") = 14.7 "Atmospheric pressure";
    
    //=============
    // Variable Section 		
    Real n (unit="mol") "Number or moles of nitrogen";
    Real V (unit="L") "Volume of nitrogen";
    Real T (unit="K") "Temperature of nitrogen in Kelvin";
    Real P (unit="psi") "Absolute pressure of Nitrogen";
    Real V_ideal (unit="L/mol") "Ideal specific molar volume";
    
    //=============
    // Equation Section 
    equation
        n = m / M; //Calculation of number of moles
        T = T_c+273; //Conversion of temperature from degC to K
        P = P_g + P_atm; //Converting gauge pressure to absolute
        V = n * R * T / P * 14.7; //From ideal gas law, conversion of atm to psi 1 atm = 14.7 psi
        V_ideal = V/n; //Verify that this value is less than 5 L/mol
                        
end Ex5_2_1;
//===================================================================