//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.3-2 Page 251
//Title: Material Balances around a condenser
//===================================================================
package Ex6_3_2
    model Ex6_3_2_1
        //=============
        // Parameter Section
        parameter Real y_H2O = 0.1 "Vapour mole fraction of H2O";
        parameter Real P (unit = "mmHg") = 5260 "Pressure of stream";
        parameter Real p_star_H2O (unit = "mmHg") = 760 "Vapour pressure of pure H2O in the stream";
        parameter Real T (unit = "degC") = 100 "Temperature of the system";
        
        //=============
        // Variable Section 	
        Real p_H2O (unit = "mmHg") "Partial pressure of pure H2O in the stream";
        Real T_dp (unit = "degC") "Dew point temperature of the stream";
        Real T_superheat (unit = "degC") "Degrees of superheat of the air";
        //=============
        // Equation Section 
        equation
            p_H2O = P * y_H2O;
            T_dp = 90; //Table B.3
            T_superheat = T - T_dp;
                            
    end Ex6_3_2_1;
    //===================================================================
    model Ex6_3_2_2
        //=============
        // Parameter Section
        parameter Real y_H2O = 0.1 "Vapour mole fraction of H2O";
        parameter Real n (unit ="mol") = 100 "Moles of feed entering the condenser";
        parameter Real T (unit = "degC") = 80 "Temperature of outlet";
        parameter Real p_star_H2O_100 (unit = "mmHg") = 760 "Vapour pressure of pure H2O at 100 degC";
        parameter Real p_star_H2O_80 (unit = "mmHg") = 355 "Vapour pressure of pure H2O at 80 degC";
        parameter Real P (unit = "mmHg") = 5260 "Pressure of stream";
        
        //=============
        // Variable Section 
        Real y "Mole fraction of H2O in the leaving air";
        Real n2 (unit = "moles") "Moles of outlet from condenser";
        Real n1 (unit = "moles") "Moles of condensed water";
        Real p_c (unit = "%") "Percentage condensation";
        //=============
        // Equation Section 
        equation        
            y* P = p_star_H2O_80; //Raoult's Law
            n * (1-y_H2O) = n2 * (1-y); //Dry air balance
            n = n1 + n2; //Total mole Balance
            p_c = n1 / (n * y_H2O) *100;
    end Ex6_3_2_2;
    //===================================================================
    model Ex6_3_2_3
        //=============
        // Parameter Section
        parameter Real y_H2O = 0.1 "Vapour mole fraction of H2O";
        parameter Real n (unit ="mol") = 100 "Moles of feed entering the condenser";
        parameter Real T (unit = "degC") = 80 "Temperature of outlet";
        parameter Real p_star_H2O_100 (unit = "mmHg") = 760 "Vapour pressure of pure H2O at 100 degC";
        parameter Real P (unit = "mmHg") = 8500 "Pressure of outlet stream";
        
        //=============
        // Variable Section 
        Real y "Mole fraction of H2O in the leaving air";
        Real n2 (unit = "moles") "Moles of outlet from condenser";
        Real n1 (unit = "moles") "Moles of condensed water";
        Real p_c (unit = "%") "Percentage condensation";
        //=============
        // Equation Section 
        equation        
            y* P = p_star_H2O_100; //Raoult's Law
            n * (1-y_H2O) = n2 * (1-y); //Dry air balance
            n = n1 + n2; //Total mole Balance
            p_c = n1 / (n * y_H2O) *100;
    end Ex6_3_2_3;
    //===================================================================
    
end Ex6_3_2;
//===================================================================
