//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.6-2 Page 331
//Title: Energy Balance on a Two-Component Process
//===================================================================
model Ex7_6_2
    //=============
    // Parameter Section
    parameter Real m_in (unit = "kg/s") = 1 "Inlet mass flow rate";
    parameter Real x1 = 0.6 "Mass fraction of ethane";
    parameter Real x2 = 0.4 "Mass fraction of butane";
    parameter Real Hcap1_in (unit = "kJ/kg") = 314.3 "Specific enthalpy of ethane at inlet"; //From page 2-234 of Perry's Chemical Engineer's Handbook
    parameter Real Hcap2_in (unit = "kJ/kg") = 30.0 "Specific enthalpy of butane at inlet"; //From page 2-223 of Perry's Chemical Engineer's Handbook
    parameter Real Hcap1_out (unit = "kJ/kg") = 434.5 "Specific enthalpy of ethane at outlet"; //From page 2-234 of Perry's Chemical Engineer's Handbook
    parameter Real Hcap2_out (unit = "kJ/kg") = 130.2 "Specific enthalpy of butane at outlet"; //From page 2-223 of Perry's Chemical Engineer's Handbook
    
    //=============
    // Variable Section 	
    Real m1 (unit = "kg/s") "Mass flow rate of ethane";
    Real m2 (unit = "kg/s") "Mass flow rate of butane";
    Real delH (unit = "kJ") "Enthalpy change occuring in the boiler";
    Real Qdot (unit = "kJ/kg") "Heat input required";
    Real W (unit = "kJ /s") "Work extracted from fluid";    
    Real delEp (unit = "kJ/s") "Change in potential energy of streams";    
    Real delEk (unit = "kJ/s") "Change in kinetic energy of streams";    
    
    //=============
    // Equation Section 
    equation
        m1 = m_in *x1;  
        m2 = m_in *x2;
        delH = (m1 * Hcap1_out + m2 * Hcap2_out) - (m1 * Hcap1_in + m2 * Hcap2_in);
        W = 0;
        delEk = 0;
        delEp = 0;
        Qdot - W = delH + delEk + delEp;
        
end Ex7_6_2;