//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.7-3 Page 336
//Title: Hydraulic Power Generation
//===================================================================
model Ex7_7_3
    //=============
    // Parameter Section
    parameter Real P1 (unit = "kPa") = 207 "Inlet pressure";
    parameter Real delz (unit = "m") = -103 "Change in height";
    parameter Real P2 (unit = "kPa") = 124 "Outlet pressure";
    import Modelica.Constants.g_n;
    parameter Real ro (unit = "kg/m^3") = 1000 "Density of water";
    parameter Real Ws (unit = "MW") = 1 "Work output";
    
    //=============
    // Variable Section 
    Real mdot (unit = "kg/s") "Mass flow rate of water";	
    Real delP (unit = "N/m^2") "Pressure drop";
   
    //=============
    // Equation Section 
    equation
        delP/ ro + g_n * delz = -Ws * 1e6 / mdot;
        delP = (P2 - P1) * 1e3; //Multiplying by 1000 to convert kPa to N/m^2
        
end Ex7_7_3;