//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-2 Page 379
//Title: Vaporization and Heating
//===================================================================
model Ex8_4_2
    //=============
    // Parameter Section
    parameter Real n_dot (unit = "mol/h") = 100 "Mass flow rate of n-hexane";
    parameter Real P (unit = "bar") = 7 "Pressure of n-hexane";
    parameter Real T_final (unit = "degC") = 300 "Final temperature of the stream";
    parameter Real T_init (unit = "degC") = 25 "Initial temperature of the stream";
    parameter Real [4] const = {0.13744, 40.85e-5, -23.92e-8, 57.66e-12}; //Polynomial coefficients for n-hexane vapour
    //Polynomial formula for specific heat are taken from Table B.2 Appendix B
    parameter Real Cp_l (unit = "kJ/mol degC") = 0.2163 "Specific heat of liquid n-hexane";// from Table B.2
    parameter Real ro (unit = "kg/L") = 0.659 "Density of liquid n-hexane"; //From Table B.1
    parameter Real MW (unit = "kg/mol") = 86.17e-3  "Molar mass of n-hexane";
    
    //=============
    // Variable Section
    Real delHcap_v (unit = "kJ/mol") "Enthalpy of vaporisation of methanol";
    Real Q_dot (unit = "kW") "Required heat rate";
    Real delHcap (unit = "kJ/mol") "Overall Specific Enthalpy change";
    Real delHcapA (unit = "kJ/mol") "Specific Enthalpy change in step A";
    Real delHcapD (unit = "kJ/mol") "Specific Enthalpy change in step D";
    Real delHcapG (unit = "kJ/mol") "Specific Enthalpy change in step G";
    Real delH_dot (unit = "kW") "Enthalpy change per unit time";    
    
    //=============
    // Equation Section 
    equation
        delHcap_v = 28.85; //From Table B.1
        delHcapD = delHcap_v;
        delHcapA = (1/ro * (1.013 - P) * MW * 0.008314 / 0.08314) + Cp_l * (69 - T_init);
        delHcapG = ((const[1]* (T_final - 69)) + (const[2] /2 * (T_final^2 - 69^2)) + (const[3] /3 * (T_final^3 - 69^3)) + (const[4] /4 * (T_final^4 - 69^4)));
        delHcap = delHcapA + delHcapD + delHcapG;
        delH_dot = n_dot * delHcap / 3600;
        Q_dot = delH_dot;
        
end Ex8_4_2;
//===================================================================