//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.4-6 Page 390
//Title: Material and Energy Balances on an Air Conditioner
//===================================================================
model Ex8_4_6
    //=============
    // Parameter Section
    parameter Real hr (unit = "%") = 80 "Percentage relative humidity";
    parameter Real V_dot (unit = "ft^3/min") = 1000 "Volumetric flow rate of humid air";
    parameter Real ha1 (unit = "lb H2O/lb DA") = 0.018 "Humidity of inlet air"; //Figure 8.4-2 page 386
    parameter Real ha2 (unit = "lb H2O/lb DA") = 0.0079 "Humidity of outlet air"; //Figure 8.4-2 page 386
    parameter Real m (unit = "lb DA") = 1 "Mass of inlet dry air";
    parameter Real H1cap (unit = "BTU/lb DA") = 38.8 "Specific enthalpy of inlet humid air"; //Figure 8.4-2 page 386
    parameter Real H2cap (unit = "BTU/lb DA") = 20.9 "Specific enthalpy of outlet humid air"; //Figure 8.4-2 page 386
    parameter Real T1 (unit ="degF") = 80 "Inlet temperature of humid air";
    parameter Real T2 (unit ="degF") = 51 "Outlet temperature of humid air";    
    parameter Real VHcap (unit = "ft^3/lb DA") = 13 "Specific volume of feed humid air"; //Figure 8.4-2 page 386
    
    //=============
    // Variable Section
    Real Q (unit = "BTU") "Heat required by air cooler for 1 lb humid air feed";
    Real m1 (unit = "lb H2O (v)") "Mass of water vapour in inlet air";
    Real m2 (unit = "lb H2O (v)") "Mass of water vapour in outlet air";
    Real m3 (unit = "lb H2O (l)") "Mass of water condensed";
    Real F_c "Fraction of water condensed";
    Real H3cap (unit = "BTU/lb")  "Specific enthalpy of condensate";
    Real Qdot (unit = "BTU/min") "Heat rate required by air cooler";
    
    //=============
    // Equation Section 
    equation
        m1 = m * ha1;
        m2 = m * ha2;
        m1 = m2 + m3; //H2O mass balance
        F_c = m3/m1;
        H3cap = m * (T2 - 32); //32 degF is reference temperature
        Q = -m * H1cap + m * H2cap + m3 * H3cap;
        Qdot = Q * V_dot / VHcap;
        
end Ex8_4_6;
//===================================================================