//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-8: Balances on Nonreactive Processes
//Example: 8.5-5 Page 405
//Title: Equilibrium Flash Vaporization
//===================================================================
model Ex8_5_5
    //=============
    // Parameter Section
    parameter Real m_dot_f (unit = "lb / h") = 100 "Mass flow rate of feed";
    parameter Real x_f (unit = "lb NH3/ lb") = 0.3 "Feed mass fraction of NH3";
    parameter Real x_v (unit = "lb NH3/ lb") = 0.89 "Mass fraction of NH3 in vapour stream";
    parameter Real HcapF (unit = "Btu/lb") = 100 "Specific enthalpy of feed";
    
    //=============
    // Variable Section
    Real m_dot_l (unit = "lb / h") "Mass flow rate of liquid";
    Real m_dot_v (unit = "lb / h") "Mass flow rate of vapour";
    Real x_l (unit = "lb NH3/ lb") "Mass fraction of NH3 in liquid stream";
    Real HcapV (unit = "Btu/lb") "Specific enthalpy of vapour";
    Real HcapL (unit = "Btu/lb") "Specific enthalpy of liquid";
    Real T (unit = "degF") "Temperature of leaving streams";
    Real Qdot (unit = "Btu/h") "Heat requirement";
    
    //=============
    // Equation Section 
    equation
        //From figure 8.5-2 page 403
        x_l = 0.185;
        T = 120;
        HcapV = 728;
        HcapL = 45;
        //============
        m_dot_l / m_dot_f = (x_v - x_f)/(x_v - x_l);
        m_dot_f = m_dot_l + m_dot_v; //Mass balance
        Qdot = m_dot_v * HcapV + m_dot_l * HcapL - m_dot_f * HcapF;
        
        
end Ex8_5_5;
//===================================================================
//Value of answer varies from that given in the text book due to rounding off the variables in the text