//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.5-3 Page 456
//Title: Energy Balance on an Adiabatic Reactor
//===================================================================
model Ex9_5_3
    //Reaction given is C2H5OH -> CH3CHO + H2
    //=============
    // Parameter Section
    parameter Real [4] cp_CH3CHO = {0.05048, 1.326e-4, -8.050e-8, 2.38e-11} "Polynomial coefficients of Cp of CH3CHO"; //Table B.2 page 636
    parameter Real [4] cp_C2H5OH = {61.34e-3, 15.72e-5, -8.749e-8, 19.83e-12} "Polynomial coefficients of Cp of C2H5OH"; //Table B.2 page 636
    parameter Real [4] cp_H2 = {28.24e-3, 0.00765e-5, 0.3288e-8, -0.8698e-12} "Polynomial coefficients of Cp of H2"; //Table B.2 page 636
    parameter Real n_in_C2H5OH (unit = "mol") = 100 "Inlet moles of C2H5OH";
    parameter Real T_in (unit = "degC") = 400 "Inlet temperature";
    parameter Real n_out_C2H5OH (unit = "mol") = 70 "Outlet moles of C2H5OH";
    parameter Real n_out_CH3CHO (unit = "mol") = 30 "Outlet moles of CH3CHO";
    parameter Real n_in_CH3CHO (unit = "mol") = 0 "Inlet moles of CH3CHO";
    parameter Real n_out_H2 (unit = "mol") = 30 "Outlet moles of H2";
    parameter Real delHf_C2H5OH (unit = "kJ/mol") = -235.31 "Standard enthalpy of formation of C2H5OH";
    parameter Real delHf_CH3CHO (unit = "kJ/mol") = -166.2 "Standard enthalpy of formation of CH3CHO";
    parameter Real delHf_H2 (unit = "kJ/mol") = 0 "Standard enthalpy of formation of H2";
    parameter Real nu_CH3CHO (unit = "kJ/mol") = 1 "Stoichiometric coefficient of CH3CHO";
    parameter Real nu_C2H5OH (unit = "kJ/mol") = -1 "Stoichiometric coefficient of C2H5OH";
    parameter Real nu_H2 (unit = "kJ/mol") = 1 "Stoichiometric coefficient of H2";
                    
    //=============
    // Variable Section
    Real T_ad (unit = "degC") "Adiabatic outlet temperature";
    Real H1cap (unit = "kJ/mol") "Specific enthalpy of C2H5OH at inlet";
    Real H2cap (unit = "kJ/mol") "Specific enthalpy of C2H5OH at outlet";
    Real H3cap (unit = "kJ/mol") "Specific enthalpy of CH3CHO at outlet";
    Real H4cap (unit = "kJ/mol") "Specific enthalpy of H2 at outlet";
    Real epsilon (unit = "mol") "Extent of reaction";
    Real delHr (unit = "kJ/mol") "Standard heat of reaction";
    
    //=============
    // Equation Section
    equation
        epsilon = (n_out_CH3CHO - n_in_CH3CHO) / nu_CH3CHO;
        delHr = nu_CH3CHO * delHf_CH3CHO + nu_C2H5OH * delHf_C2H5OH + nu_H2 * delHf_H2;
        H1cap = (cp_C2H5OH[1] * (T_in - 25)) + (cp_C2H5OH[2]/2 * (T_in^2 - 25^2)) + (cp_C2H5OH[3]/3 * (T_in^3 - 25^3)) + (cp_C2H5OH[4]/4 * (T_in^4 - 25^4)) ;
        H2cap = (cp_C2H5OH[1] * (T_ad - 25)) + (cp_C2H5OH[2]/2 * (T_ad^2 - 25^2)) + (cp_C2H5OH[3]/3 * (T_ad^3 - 25^3)) + (cp_C2H5OH[4]/4 * (T_ad^4 - 25^4)) ;
        H3cap = (cp_CH3CHO[1] * (T_ad - 25)) + (cp_CH3CHO[2]/2 * (T_ad^2 - 25^2)) + (cp_CH3CHO[3]/3 * (T_ad^3 - 25^3)) + (cp_CH3CHO[4]/4 * (T_ad^4 - 25^4)) ;
        H4cap = (cp_H2[1] * (T_ad - 25)) + (cp_H2[2]/2 * (T_ad^2 - 25^2)) + (cp_H2[3]/3 * (T_ad^3 - 25^3)) + (cp_H2[4]/4 * (T_ad^4 - 25^4)) ;
        epsilon * delHr + H2cap * n_out_C2H5OH + H3cap * n_out_CH3CHO + H4cap * n_out_H2 - H1cap * n_in_C2H5OH = 0; //Energy balance
                
end Ex9_5_3;