//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-9: Balances on Reactive Processes
//Example: 9.6-1 Page 465
//Title: Calculation of a Heating Value
//===================================================================
model Ex9_6_1
    //=============
    // Parameter Section
    parameter Real y = 0.85 "Mole fraction of methane";
    parameter Real delHc_m (unit = "kJ/ mol") = -802 "Heat of combustion of methane";
    parameter Real delHc_e (unit = "kJ/ mol") = -1428 "Heat of combustion of ethane";
    parameter Real delHv_H2O (unit = "kJ/mol") = 44.013 "Heat of vapourisation of water";
                    
    //=============
    // Variable Section
    Real m_m (unit = "g") "Mass of methane";
    Real m_e (unit = "g") "Mass of ethane";
    Real m (unit = "g") "Total mass of fuel";
    Real x_CH4 (unit = "g CH4/ g fuel") "Mass fraction of methane";    
    Real x_C2H6 (unit = "g C2H6/ g fuel") "Mass fraction of ethane";
    Real HHV_CH4 (unit = "kJ/g") "High heat value of methane";
    Real HHV_C2H6 (unit = "kJ/g") "High heat value of ethane";
    Real HHV (unit = "kJ/g") "High heat value of mixture";
    
    //=============
    // Equation Section
    equation
        m_m = 1 * y * 16;
        m_e = 1 * (1-y) * 30;
        m = m_e + m_m;
        x_CH4 = m_m / m;
        x_C2H6 = m_e / m;
        HHV_CH4 = (-delHc_m + 2 * delHv_H2O)/16;
        HHV_C2H6 = (-delHc_e + 3 * delHv_H2O)/30;
        HHV = HHV_CH4 * x_CH4 + HHV_C2H6 * x_C2H6;
                
end Ex9_6_1;