//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-10: Computer-Aided Balance Calculations
//Example: 10.3-1 Page 523
//Title: Simulation and design of a Two-Column Separation Process
//===================================================================
model Ex10_3_1
    //=============
    // Parameter Section
    parameter Real mf_B (unit = "kg") = 35 "Mass of benzene in feed";
    parameter Real mf_T (unit = "kg") = 50 "Mass of toluene in feed";    
    parameter Real mf_X (unit = "kg") = 15 "Mass of Xylene in feed";
    parameter Real xo1_B (unit = "kg B/ kg") = 0.673 "Mass fraction of benzene in overhead of first column";
    parameter Real xo1_T (unit = "kg T/ kg") = 0.306 "Mass fraction of toluene in overhead of first column";
    parameter Real xo1_X (unit = "kg X/ kg") = 0.021 "Mass fraction of xylene in overhead of first column";
    parameter Real xo2_B (unit = "kg B/ kg") = 0.059 "Mass fraction of benzene in overhead of second column";
    parameter Real xo2_T (unit = "kg T/ kg") = 0.926 "Mass fraction of toluene in overhead of second column";
    parameter Real xo2_X (unit = "kg X/ kg") = 0.015 "Mass fraction of xylene in overhead of second column";
                    
    //=============
    // Variable Section
    Real n1 (unit = "kg") "Mass of overhead from column 1";
    Real n2 (unit = "kg B") "Mass of benzene in bottoms of column 1";
    Real n3 (unit = "kg T") "Mass of toluene  in bottoms of column 1";
    Real n4 (unit = "kg X") "Mass of xylene in bottoms of column 1";
    Real n5 (unit = "kg") "Mass of overhead from column 2";
    Real n6 (unit = "kg B") "Mass of benzene in bottoms of column 2";
    Real n7 (unit = "kg T") "Mass of toluene  in bottoms of column 2";
    Real n8 (unit = "kg X") "Mass of xylene in bottoms of column 2";
    
    //=============
    // Equation Section
    equation
        mf_B = xo1_B * n1 + n2; //Column 1 benzene balance
        mf_T = xo1_T * n1 + n3; //Column 1 toluene balance
        mf_X = xo1_X * n1 + n4; //Column 1 xylene balance
        n2 = xo2_B * n5 + n6; //Column 2 benzene balance
        n3 = xo2_T * n5 + n7; //Column 2 toluene balance        
        n4 = xo2_X * n5 + n8; //Column 2 xylene balance
        n7 = 0.1 * mf_T; //10% Toluene recovered
        n8 = 0.9 * mf_X; //90% recovery of xylene
                                
end Ex10_3_1;                
//===================================================================