//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-11: Balances on Transient Processes
//Example: 11.1-2 Page 547
//Title: Water balance on a city reservoir
//===================================================================
model Ex11_1_2
    //=============
    // Parameter Section
    parameter Real m_out (unit = "L/day") = 1e7 "Water consumption rate";
    parameter Real V_initial (unit = "L/day") = 1e9 "Initial volume of water in reservoir";
    
    //=============
    // Variable Section
    Real m_in (unit = "L/day") "Water input rate";
    Real V (unit = "L", start = 1e9) "Volume of reservoir";
    Real V_final (unit = "L") "Volume of reservoir at end of drought";
      
    //=============
    // Equation Section 
    equation
        m_in = 1e6 * exp(-time/100);
        der(V) = m_in - m_out;
        V_final = V_initial - 1e6 * 100 * exp(-60/100) + 1e6 * 100 * exp(-0/100) - m_out * (60 - 0);
end Ex11_1_2;
//===================================================================