//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-11: Balances on Transient Processes
//Example: 11.2-1 Page 548
//Title: Mass balance on a water storage tank
//===================================================================
//Set simulation time greater than 60 seconds
model Ex11_2_1
    //=============
    // Parameter Section
    parameter Real V_in (unit = "m^3 / s") = 0.050 "Inlet volumetric flow rate of liquid";
    
    //=============
    // Variable Section
    Real V_out (unit = "m^3/ s") "Volumetric leak rate";
    Real V (unit = "m^3", start = 1.2) "VOlume of fluid in tank";
    
    //=============
    // Equation Section 
    equation
        V_out = 0.0025 * time;
        if time>57 then
            V = 0;
        else
            V = 1.2 + V_in * time - V_out *time/2;
        end if;
                 
end Ex11_2_1;
//===================================================================