//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-11: Balances on Transient Processes
//Example: 11.3-2 Page 557
//Title: Transient behaviour of an Air-cooling system
//===================================================================
model Ex11_3_2
    //Set a simulation time of 5 time units
    //=============
    // Parameter Section
    parameter Real Qgen (unit = "Btu/min") = 8530 "Heat generated";
    parameter Real mdot (unit = "lb-mole/ min") = 6 "Air circulation rate";
    parameter Real T0 (unit = "degF") = 65 "Inlet temperature";
    parameter Real Cv (unit = "Btu/lbmol degF") = 5 "Specific heat capacity of the air";
    parameter Real Ws (unit = "Btu/min") = 0 "Work extracted";
    parameter Real M (unit = "lb-mole") = 0.2 "Amount of air present inside the casing";
    parameter Real R (unit = "Btu/ lb-mole degF") = 1.99 "Universal Gas constant";
    
    //=============
    // Variable Section
    Real T (unit = "degF", start = 65) "Outlet air temperature";
    Real Tss (unit = "degF") "Steady state outlet air temperature";
    Real Qlost (unit = "Btu/min") "Heat loss from engine";
    Real Qdot (unit = "Btu/min") "Steady state heat transfer rate from engine";
    Real Cp (unit = "Btu / lb-mole degF") "Specific heat capacity at constant pressure";
            
    //=============
    // Equation Section 
    equation
        Qdot = Qgen - 33 * (Tss - T0);
        Cp = Cv + R;
        mdot* Cp * (T0 - Tss) + Qdot - Ws = 0; //Energy balance
        Qlost = 33 * (T - T0);
        T = 179 - 114 * exp(-74.9*time/60);
                         
end Ex11_3_2;
//===================================================================