//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000

//Chapter-3: Processes and Process Variables
//Example: 3.3-4 Page 51
//Title: Calculation of an Average Molecular Weight
//===================================================================
package Ex3_3_4
    //=============
    
    model Ex3_3_4_1
        // Parameter Section 
        parameter Real yN2 = 0.79 "Mole fraction of N2 in air";
        parameter Real yO2 = 0.21 "Mole fraction of O2 in air";
        parameter Real MN2 (unit="kg/kmol") = 28 "Molar mass of N2";
        parameter Real MO2 (unit="kg/kmol") = 32 "Molar mass of O2";
        
        //=============
        // Variable Section 
        Real M_bar (unit="kg/kmol") "Average molecular weight";
        
        //=============
        // Equation  Section 
        equation
          M_bar = yN2* MN2 + yO2* MO2;
        
    end Ex3_3_4_1;
    //===================================================================
    
    model Ex3_3_4_2
        // Parameter Section 
        parameter Real xN2 = 0.767 "Mass fraction of N2 in air";
        parameter Real xO2 = 0.233 "Mass fraction of O2 in air";
        parameter Real MN2 (unit="g/mol") = 28 "Molar mass of N2";
        parameter Real MO2 (unit="g/mol") = 32 "Molar mass of O2";
        
        //=============
        // Variable Section 
        Real M_bar (unit="g/mol") "Average molecular weight";
        
        //=============
        // Equation  Section 
        equation
          (1/M_bar) = (xN2/ MN2) + (xO2/ MO2);
        
    end Ex3_3_4_2;
    //===================================================================

end Ex3_3_4;
