//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-3: Processes and Process Variables
//Example: 3.4-2 Page 55
//Title: Calculation of a Pressure as a Head of a Fluid
//===================================================================
model Ex3_4_1
    //=============
    // Parameter Section 
    parameter Real P (unit="Pa") = 2e5 "Given pressure in Pascals";
    parameter Real ro_Hg (unit= "kg/m^3") = 13600 "Density of mercury";
    parameter Real g (unit = "N/kg") = 9.807 "Acceleration due to gravity";
    
    //=============
    // Variable Section 
    Real P_h (unit = "mmHg") "Pressure in mmHg";
    
    //=============
    // Equation  Section 
    equation
        P_h = P / (ro_Hg * g) * 1000; //Multiplied by 1000 to convert m to mm
      
end Ex3_4_1;