//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.2-2 Page 86
//Title: Material Balances on a Continuous Distillation Process
//===================================================================
model Ex4_2_2
    //=============
    // Parameter Section 
    parameter Real m_1_f (unit = "kg B/hr") = 500 "Mass flow rate of benzene in feed";
    parameter Real m_2_f (unit = "kg T/hr") = 500 "Mass flow rate of toluene in feed";
    parameter Real m_1_t (unit = "kg B/hr") = 450 "Mass flow rate of benzene at top";
    parameter Real m_2_b (unit = "kg T/hr") = 475 "Mass flow rate of toluene at bottom";
    
    //=============
    // Variable Section 
    Real m_2_t (unit = "kg T/hr") "Mass flow rate of toluene at top";
    Real m_1_b (unit = "kg B/hr") "Mass flow rate of benzene at bottom";
    
    //=============
    // Equation  Section 
    equation
      m_1_f = m_1_t + m_1_b; //Benzene balance
      m_2_f = m_2_t + m_2_b; //Toluene balance
    
end Ex4_2_2;