//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.2-3 Page 87
//Title: Balances on a Batch Mixing Process
//===================================================================
model Ex4_2_3
//=============
// Parameter Section 
parameter Real m_1 (unit = "g") = 200 "Mass of first mixture";
parameter Real m_2 (unit = "g") = 150 "Mass of second mixture";
parameter Real x_1 (unit = "%") = 40 "Mass percentage of methanol in first mixture";
parameter Real x_2 (unit = "%") = 70 "Mass percentage of methanol in second mixture";

//=============
// Variable Section 
Real m (unit = "g") "Total mass of the product";
Real x (unit = "g Methanol/ g") "Mass fraction of methanol in product";

//=============
// Equation  Section 
equation
  m = m_1 + m_2; //Total mass balance
  m * x = (m_1 * x_1/100) + (m_2 * x_2/100); //Methanol Balance

end Ex4_2_3;