//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.3-5 Page 102
//Title: Material Balances on a DIstillation Column
//===================================================================
//NOTE: The values computed and the values in the textbook vary slightly due to approximations in the book
model Ex4_3_5
		//=============
		// Parameter Section 
		parameter Real v_1 (unit="l/h") = 2000 "Volumetric feed rate";
		parameter Real y_B1	(unit = "kg B/kg") = 0.45 "Mass fraction of B in feed";
		parameter Real y_T1	(unit = "kg T/kg") = 0.55 "Mass fraction of T in feed";
		parameter Real sp_g1 = 0.872 "Specific gravity of feed";
		parameter Real x_B2	(unit = "mol B/mol") = 0.95 "Mole fraction of B in overhead";
		parameter Real x_T2	(unit = "mol T/mol") = 0.05 "Mole fraction of T in overhead";
		parameter Real MB (unit = " g B/ mol B") = 78.11 "Molar mass of B";
		parameter Real MT (unit = " g B/ mol B") = 92.13 "Molar mass of T";
		//=============
		// Variable Section 		
		Real m1 (unit = "kg/h") "Mass flow rate of feed";
		Real m2 (unit = "kg/h") "Mass flow rate of overhead";
		Real m3 (unit = "kg/h") "Mass flow rate of bottoms";
		Real m_B3 (unit = "kg/h") "Mass flow rate of B in bottom";
		Real m_T3 (unit = "kg/h") "Mass flow rate of T in bottom";
		Real y_B2 (unit = "mol B/ mol") "Mass fraction of B in bottoms";
		Real y_T2 (unit = "mol T/ mol") "Mass fraction of T in bottoms";
		Real y_B3 (unit = "mol B/ mol") "Mass fraction of B in overhead";
		Real y_T3 (unit = "mol T/ mol") "Mass fraction of T in overhead";
		//=============
		// Equation Section 
		equation
				y_B2 = (x_B2/MB) / ((x_B2/MB) + (x_T2/MT));
				y_T2 = 1- y_B2;
				m1 = v_1 * sp_g1; //Converting volume rate to mass rate
				m_B3 = 0.08 * m1 * y_B1; //8 % of benzene in feed is present in bottoms
				m3 = m_B3 + m_T3;
				m1 * y_B1 = m2 * y_B2 + m_B3; //Benzene balance
				m1 * y_T1 = m2 * y_T2 + m_T3; //Toluene balance				
				y_B3 = m_B3/m3;
				y_T3 = m_T3/m3;
end Ex4_3_5;
//===================================================================