//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.5-1 Page 110
//Title: Material and Energy Balances on an Air Conditioner
//===================================================================
model Ex4_5_1
    //=============
    // Parameter Section
    parameter Real x1 = 0.96 "Mole fraction of dry air in fresh feed";
    parameter Real x2 = 0.977 "Mole fraction of dry air in mixed air";
    parameter Real x4 = 0.983 "Mole fraction of dry air in conditioned air";
   
    //=============
    // Variable Section 		
    Real n1 (unit = "mol") "Moles of fresh air fed to the system";
    Real n2 (unit = "mol") "Moles of mixed air entering teh air conditioner";
    Real n3 (unit = "mol") "Moles of water condensed";
    Real n5 (unit = "mol") "Moles of air recycled";
    
    //=============
    // Equation Section 
    equation
        x1 * n1 = x4 * 100; //Overall dry air balance";
        n1 = n3 + 100; //Overall mole balance
        n1 +n5 = n2; //Mole balance at mixing point 
        (1- x1) * n1 + (1- x4) * n5 = (1- x2) * n2; //Water balance at mixing point       
        
end Ex4_5_1;
//===================================================================