//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.6-1 Page 120
//Title: Reaction Stoichiometry
//===================================================================
model Ex4_6_1
    //=============
    // Parameter Section
    parameter Real nF (unit = "mol") = 100 "Moles of feed mixture";
    parameter Real xF_C3H6 (unit = "mol C3H6/ mol") = 0.1  "Mole fraction of propylene in feed";
    parameter Real xF_NH3 (unit = "mol NH3/ mol") = 0.12  "Mole fraction of ammonia in feed";
    
    //=============
    // Variable Section 		
    Real n_NH3_0 (unit = "mol NH3") "Moles of ammonia present in feed";
    Real n_C3H6_0 (unit = "mol C3H6") "Moles of propylene present in feed";
    Real n_O2_0 (unit = "mol O2") "Moles of O2 present in feed";
    Real n_N2_0 (unit = "mol N2") "Moles of  N2 present in feed";
    Real r_NH3 "Ratio of actual number of moles to moles of propylene";
    Real r_O2 "Ratio of actual number of moles to moles of propylene";
    Real n_NH3_a (unit = "mol NH3") "Moles of ammonia required";
    Real n_O2_a (unit = "mol O2") "Moles of oxygen required";
    Real e_NH3 (unit = "%") "% Excess of NH3";
    Real e_O2 (unit = "%") "% Excess of O2";
    Real epsilon (unit ="mol") "Extent of reaction";
    Real n_NH3 (unit = "mol NH3") "Moles of ammonia present in effluent";
    Real n_C3H6 (unit = "mol C3H6") "Moles of propylene present in effluent";
    Real n_O2 (unit = "mol O2") "Moles of O2 present in effluent";
    Real n_C3H3N (unit = "mol C3H3N") "Moles of C3H3N present in effluent";
    Real n_H2O (unit = "mol H2O") "Moles of H2O present in effluent";
    Real n_N2 (unit = "mol N2") "Moles of N2 present in effluent";
    
    //=============
    // Equation Section 
    equation
        n_NH3_0 = nF * xF_NH3;
        n_C3H6_0 = nF * xF_C3H6;
        n_O2_0 = nF * (1 - xF_NH3 - xF_C3H6) * 0.21;
        n_N2_0 = n_O2_0 / 0.21 * 0.79;
        r_NH3 = n_NH3_0 / n_C3H6_0;
        r_O2 = n_O2_0 / n_C3H6_0;
        n_NH3_a = n_C3H6_0 * 1 /1;
        n_O2_a = n_C3H6_0 *1.5 /1;
        e_NH3 = (n_NH3_0 - n_NH3_a) / n_NH3_a * 100;
        e_O2 = (n_O2_0 - n_O2_a) / n_O2_a * 100;
        n_C3H6 = 0.7 * n_C3H6_0;
        epsilon = n_C3H6_0 * 0.3;
        n_NH3 =  n_NH3_0 - epsilon;
        n_O2 = n_O2_0 -  1.5*epsilon;
        n_C3H3N = epsilon;
        n_N2 = n_N2_0;
        n_H2O = 3 * epsilon;
        
end Ex4_6_1;
//===================================================================