//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.6-2 Page 120
//Title: Calculation of an Equilibrium Composition
//===================================================================
model Ex4_6_2
    //=============
    // Parameter Section
    parameter Real nCO_f (unit = "mol") = 1 "Moles of CO in feed";
    parameter Real nH2O_f (unit = "mol") = 2 "Moles of H2O in feed";
        
    //=============
    // Variable Section 		
    Real epsilon (unit = "mol", start = 0) "Extent of reaction";
    Real n_total (unit = "mol") "Total number of moles present";
    Real yCO "Mole fraction of CO";
    Real yH2O "Mole fraction of H2O";
    Real yCO2 "Mole fraction of CO2";
    Real yH2 "Mole fraction of H2";
    Real nCO (unit = "mol") "Moles of CO at equilibrium";
    Real nH2O (unit = "mol") "Moles of H2O at equilibrium";
    Real nCO2 (unit = "mol") "Moles of CO2 at equilibrium";
    Real nH2 (unit = "mol") "Moles of H2 at equilibrium";
    Real fCO "fractional conversion of CO2";
    
    //=============
    // Equation Section 
    equation
        nCO = nCO_f - epsilon;
        nH2O = nH2O_f - epsilon;
        nCO2 = epsilon;
        nH2 = epsilon;
        n_total = nCO_f + nH2O_f;
        yCO = (nCO_f - epsilon) / n_total;
        yH2O = (nH2O_f - epsilon) / n_total;
        yCO2 = epsilon / n_total;
        yH2 = epsilon / n_total;
        yCO2 * yH2 / yCO / yH2O = 1;
        fCO = (nCO_f - nCO) / nCO_f;
        
end Ex4_6_2;
//===================================================================