//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.7-1 Page 131
//Title: Incomplete combustion of methane
//===================================================================
package Ex4_7_1
    model Ex4_7_1_1
        //=============
        // Parameter Section
        parameter Real nf (unit = "mol") = 100 "Moles in feed";
        parameter Real yCH4 = 0.078 "Mole fraction of methane in feed";
        parameter Real yO2 = 0.194 "Mole fraction of O2 in feed";
        parameter Real yN2 = 0.728 "Mole fraction of N2 in feed";    
        parameter Real fCH4 = 0.9 "Fractional conversion of methane";
        
        //=============
        // Variable Section 		
        Real nCH4 (unit = "mol") "Moles of CH4 in effluent";
        Real nCO (unit = "mol") "Moles of CO in effluent";
        Real nCO2 (unit = "mol") "Moles of CO2 in effluent";
        Real nH2O (unit = "mol") "Moles of H2O in effluent";
        Real nO2 (unit = "mol") "Moles of O2 in effluent";
        Real nN2 (unit = "mol") "Moles of N2 in effluent";
        Real GCO_1 (unit = "mol") "Moles of CO generated in reaction 1";
        Real GCO2_2 (unit = "mol") "Moles of CO2 generated in reaction 2";
        Real CCH4_1 (unit = "mol") "Moles of CH4 consumed in reaction 1";
        Real CCH4_2 (unit = "mol") "Moles of Ch4 consumed in reaction 2";
        Real GH2O_1 (unit = "mol") "Moles of H2O generated in reaction 1";
        Real GH2O_2 (unit = "mol") "Moles of H2O generated in reaction 2";
        Real CO2_1 (unit = "mol") "Moles of O2 consumed in reaction 1";
        Real CO2_2 (unit = "mol") "Moles of O2 consumed in reaction 2";
                
        //=============
        // Equation Section 
        equation
            nCH4 = nf * yCH4 * (1- fCH4);
            nN2 = nf * yN2;
            nCO2 = 8 * nCO;
            nCO = GCO_1; //CO balance
            nCO2 = GCO2_2; //CO2 balance
            nf * yCH4 = nCH4 + CCH4_1 + CCH4_2; //CH4 balance
            CCH4_1 = GCO_1;
            CCH4_2 = GCO2_2;
            nH2O = GH2O_1 + GH2O_2; //H2O balance;
            GH2O_1 = GCO_1 * 2;
            GH2O_2 = GCO2_2 * 2;
            nO2 = nf * yO2 - CO2_1 - CO2_2; //O2 balance
            CO2_1 = GCO_1 * 1.5;
            CO2_2 = GCO2_2 * 2;
            
            
    end Ex4_7_1_1;
    //===================================================================
    
    model Ex4_7_1_2
        //=============
        // Parameter Section
        parameter Real nf (unit = "mol") = 100 "Moles in feed";
        parameter Real yCH4 = 0.078 "Mole fraction of methane in feed";
        parameter Real yO2 = 0.194 "Mole fraction of O2 in feed";
        parameter Real yN2 = 0.728 "Mole fraction of N2 in feed";    
        parameter Real fCH4 = 0.9 "Fractional conversion of methane";
        
        //=============
        // Variable Section 		
        Real nCH4 (unit = "mol") "Moles of CH4 in effluent";
        Real nCO (unit = "mol") "Moles of CO in effluent";
        Real nCO2 (unit = "mol") "Moles of CO2 in effluent";
        Real nH2O (unit = "mol") "Moles of H2O in effluent";
        Real nO2 (unit = "mol") "Moles of O2 in effluent";
        Real nN2 (unit = "mol") "Moles of N2 in effluent";
                    
        //=============
        // Equation Section 
        equation
            nCH4 = nf * yCH4 * (1- fCH4);
            nN2 = nf * yN2;
            nCO2 = 8 * nCO;
            nf * yCH4 = nCH4 + nCO + nCO2; //C balance
            nf * yCH4  * 4 = nCH4 * 4 + nH2O * 2; //H balance
            nf * yO2 * 2 = nO2 * 2 + nCO + nCO2 * 2 + nH2O; //O balance
                    
    end Ex4_7_1_2;
    //===================================================================
    
    model Ex4_7_1_3
        //=============
        // Parameter Section
        parameter Real nf (unit = "mol") = 100 "Moles in feed";
        parameter Real yCH4 = 0.078 "Mole fraction of methane in feed";
        parameter Real yO2 = 0.194 "Mole fraction of O2 in feed";
        parameter Real yN2 = 0.728 "Mole fraction of N2 in feed";    
        parameter Real fCH4 = 0.9 "Fractional conversion of methane";
        
        //=============
        // Variable Section 		
        Real nCH4 (unit = "mol") "Moles of CH4 in effluent";
        Real nCO (unit = "mol") "Moles of CO in effluent";
        Real nCO2 (unit = "mol") "Moles of CO2 in effluent";
        Real nH2O (unit = "mol") "Moles of H2O in effluent";
        Real nO2 (unit = "mol") "Moles of O2 in effluent";
        Real nN2 (unit = "mol") "Moles of N2 in effluent";
        Real epsilon1 (unit = "mol") "Extent of reaction 1";
        Real epsilon2 (unit = "mol") "Extent of reaction 2";
                
        //=============
        // Equation Section 
        equation
            nCH4 = nf * yCH4 * (1- fCH4);
            nN2 = nf * yN2;
            nCO2 = 8 * nCO;
            nCH4 = nf * yCH4 - epsilon1 - epsilon2;
            nCO = epsilon1;
            nCO2 = epsilon2;
            nH2O = 2*epsilon1 + 2*epsilon2;
            nO2 = nf * yO2 - 1.5*epsilon1 - 2*epsilon2;        
            
    end Ex4_7_1_3;
    //===================================================================
end Ex4_7_1;
