//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.7-2 Page 135
//Title: Dehydrogenation of Propane
//===================================================================
model Ex4_7_2
    //=============
    // Parameter Section
    parameter Real nf (unit = "mol") = 100 "Moles of fresh propane";
       
    //=============
    // Variable Section 		
    Real n1 (unit = "mol C3H8") "Moles of propane in mixed stream";
    //Real n2 (unit = "mol C3H6") "Moles of propene in mixed stream";
    Real n3 (unit = "mol C3H8") "Moles of propane in reactor effluent";
    //Real n4 (unit = "mol C3H6") "Moles of propene in reactor effluent";
    //Real n5 (unit = "mol H2") "Moles of hydrogen in reactor effluent";
    Real n9 (unit = "mol C3H8") "Moles of propane in recycle stream";
    Real n10 (unit = "mol C3H6") "Moles of propene in recycle stream";
    Real n6 (unit = "mol C3H8") "Moles of propane in product";
    Real n7 (unit = "mol C3H6") "Moles of propene in product";
    Real n8 (unit = "mol H2") "Moles of hydrogen in product";
    Real rr (unit = "mol recycle / mol fresh feed") "Recycle ratio";
    Real sp_conv (unit = "%") "Single pass conversion";
        
    //=============
    // Equation Section 
    equation
        n6 = 0.05 * nf; //Unconverted propane is 5% of feed
        nf * 3 = n6 * 3 + n7 * 3; //C balance
        nf * 8 = n6 * 8 + n7 * 6 + n8*2; //H balance
        n6 = 0.00555 * n3;
        n10 = 0.05 * n7; 
        n3 = n6 + n9; //C3H8 balance around separator
        nf + n9 = n1; //C3H8 balance around mixing point
        rr = (n9 + n10) / nf;
        sp_conv = (n1 - n3) / n1 * 100;
        
end Ex4_7_2;
//===================================================================