//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.8-1 Page 143
//Title: Composition on Wet and Dry Basis
//===================================================================
package Ex4_8_1
    model Ex4_8_1_1
        //=============
        // Parameter Section
        parameter Real yN2 (unit = "%") = 60 "Mole percentage of N2";
        parameter Real yCO2 (unit = "%") = 15 "Mole percentage of CO2";
        parameter Real yO2 (unit = "%") = 10 "Mole percentage of O2";
          
        //=============
        // Variable Section 		
        Real ntot (unit = "mol") "Total moles of dry gas";
        Real yN2_d (unit = "mol N2 / mol dry gas") "Mole fraction of N2 on dry basis";
        Real yCO2_d (unit = "mol CO2 / mol dry gas") "Mole fraction of CO2 on dry basis";
        Real yO2_d (unit = "mol O2 / mol dry gas") "Mole fraction of O2 on dry basis";
        
        //=============
        // Equation Section 
        equation
            ntot = 100 * (yN2 + yCO2 + yO2) / 100;
            yN2_d = yN2 / ntot;
            yCO2_d = yCO2 / ntot;
            yO2_d = yO2 / ntot;
            
    end Ex4_8_1_1;
    //===================================================================
    
    model Ex4_8_1_2
        //=============
        // Parameter Section
        parameter Real yN2 (unit = "%") = 65 "Mole percentage of N2 on dry basis";
        parameter Real yCO2 (unit = "%") = 14 "Mole percentage of CO2 on dry basis";
        parameter Real yCO (unit = "%") = 11 "Mole percentage of CO2 on dry basis";
        parameter Real yO2 (unit = "%") = 10 "Mole percentage of O2 on dry basis";
        parameter Real H (unit = "mol H2O / mol wet gas") = 0.07 "Humidity of stack gas";
          
        //=============
        // Variable Section 		
        Real yN2_w (unit = "mol N2/ mol wet gas") "Wet mole fraction of N2";
        Real yCO2_w (unit = "mol N2/ mol wet gas") "Wet mole fraction of N2";
        Real yCO_w (unit = "mol N2/ mol wet gas") "Wet mole fraction of N2";    
        Real yO2_w (unit = "mol N2/ mol wet gas") "Wet mole fraction of N2";    
        Real n_H2O (unit = "mol") "Moles of H2O present";
        Real ntot (unit = "mol") "Total number of moles";
        
        //=============
        // Equation Section 
        equation
            //100 Mole dry gas basis
            n_H2O / (100 + n_H2O) = H;
            ntot = 100 * (yN2 + yCO2 + yCO + yO2) / 100 + n_H2O;
            yN2_w = 100 * yN2 / 100 / ntot;
            yCO2_w = 100 * yCO2 / 100 / ntot;
            yCO_w = 100 * yCO / 100 / ntot;
            yO2_w = 100 * yO2 / 100 / ntot;
            
    end Ex4_8_1_2;
    //===================================================================
end Ex4_8_1;
