//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.8-2 Page 145
//Title: Theoretical and Excess Air
//===================================================================
model Ex4_8_2
    //=============
    // Parameter Section
    parameter Real nf (unit = "mol C4H10 / h") = 100 "Molar feed rate of butane";
    parameter Real nair (unit = "mol air /h") = 5000 "Molar feed rate of air";
      
    //=============
    // Variable Section 	
    Real excess (unit = "%") "Percentage excess of air";
    Real nO2_th (unit = "mol/h") "Theoretical oxygen requirement";
    Real nair_th (unit = "mol/h") "Theoretical oxygen requirement";
    
    //=============
    // Equation Section 
    equation
        nO2_th = nf * 6.5;
        nair_th = nO2_th / 0.21;
        excess = (nair - nair_th) / nair_th * 100;
    
end Ex4_8_2 ;
//===================================================================