//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-4: Fundamentals of Material Balances
//Example: 4.9-1 Page 151
//Title: Material Balances in Process Design and Process Operation
//===================================================================
model Ex4_9_1
    //=============
    // Parameter Section
    parameter Real yMEK_i (unit = "mol MEK / mol") = 0.20 "Feed molar fraction of MEK";
    parameter Real n_i (unit = "mol/s") = 59.6 "Molar feed rate";
    parameter Real n_o_d (unit = "mol/s") = 48.7 "Design outlet molar feed rate";
    parameter Real n_o_e (unit = "mol/s") = 48.3 "Experimental outlet molar feed rate";
    parameter Real yMEK_o_d (unit = "mol MEK / mol") = 0.021 "Design outlet molar fraction of MEK";
    parameter Real yMEK_o_e (unit = "mol MEK / mol") = 0.063 "Experimental outlet molar fraction of MEK";
    parameter Real nMEK_b_d (unit = "mol MEK") = 10.9 "Moles of MEK condensed as per design";
    parameter Real nMEK_b_e (unit = "mol MEK") = 6.4 "Moles of MEK condensed as per experiment";
        
    //=============
    // Variable Section 	
    Real nMEK_in (unit = "mol MEK") "Moles of MEK fed";
    Real nMEK_out_d (unit = "mol MEK") "Moles of MEK in outlet as per design";
    Real nMEK_out_e (unit = "mol MEK") "Experimental number of moles of MEK in outlet";
    Real closure_e (unit = "%") "Experimental closure";
    Real closure_d (unit = "%") "Closure as per design";
    
    //=============
    // Equation Section 
    equation
        nMEK_in = n_i * yMEK_i;
        nMEK_out_d = n_o_d * yMEK_o_d + nMEK_b_d;
        nMEK_out_e = n_o_e * yMEK_o_e + nMEK_b_e;
        closure_d = nMEK_out_d / nMEK_in * 100;
        closure_e = nMEK_out_e / nMEK_in * 100;
        
end Ex4_9_1 ;
//===================================================================