//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.2-3 Page 195
//Title: Effect of T and P on Volumetric Flow Rates
//===================================================================
model Ex5_2_3
    //=============
    // Parameter Section
    parameter Real V1 (unit = "ft^3") = 10 "Inlet volume of air";
    parameter Real P1 (unit = "atm") = 1 "Inlet pressure of air";
    parameter Real T1 (unit = "degF") = 70 "Inlet temperature of air";
    parameter Real T2 (unit = "degF") = 610 "Outlet temperature of air";
    parameter Real P2 (unit = "atm") = 2.5 "Inlet pressure of air";
    
    //=============
    // Variable Section
    Real V2 (unit = "ft^3") "Exit volume of air";
    
    //=============
    // Equation Section 
    equation
        V2 = V1 * (P1/ P2) * ((T2 + 460) / (T1 + 460)); //460 added to convert degF to degR (Rankine)
        
end Ex5_2_3;
//===================================================================