//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.2-4 Page 196
//Title: Standard and True Volumetric Rates
//===================================================================
model Ex5_2_4
    //=============
    // Parameter Section
    parameter Real V1_dot (unit="SCHF") = 3.95e5 "Volumetric flow rate of methane at STP"; //SCFH stands for standard cubic feet per hour
    parameter Real T2 (unit = "degF") = 285 "Temperature of methane stream";
    parameter Real T1 (unit = "degR") = 492 "Standard temperature";
    parameter Real P1 (unit = "atm") = 1 "Standard Pressure";
    parameter Real P2 (unit = "atm") = 1.3 "Pressure of methane stream";
    
    //=============
    // Variable Section
    Real V2_dot (unit = "ft^3/h") "True volumetric flow rate of methane";
    Real n_dot (unit = "lbmol/ h") "Molar flow rate";
    
    //=============
    // Equation Section 
    equation
        V2_dot = V1_dot * (P1 /P2) * ((T2 + 460) / T1); //Adding 460 to convert T1 from degF to degR
        n_dot = V1_dot / 359; 
        
end Ex5_2_4;
//===================================================================