//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.3-3 Page 204
//Title: Estimation of Volumes using the SRK Equation of State
//===================================================================
model Ex5_3_3
    //=============
    // Parameter Section
    parameter Real T (unit = "K") =  423 "Temperature of propane";
    parameter Real n_dot (unit = "kmol/h") = 100 "Molar flow rate of propane";
    parameter Real R (unit = "Latm/molK") = 0.08206 "Gas constant";
    parameter Real Tc_p (unit ="K") = 369.6 "Critical temperature of propane at given conditions"; //Taken from Table B.1
    parameter Real Pc_p (unit ="atm") = 42 "Critical pressure of propane at given conditions"; //Taken from Table B.1
    parameter Real w_p = 0.152 "Acentric factor for propane"; //From Table 5.3-1
    parameter Real [3] P (each unit = "atm") = {0.7, 7, 70} "Pressure of the tank";
    
    //=============
    // Variable Section
    Real [3] V_dot (each unit = "m^3/h") "Volumetric flow rate of propane";
    Real [3] V_cap (each unit = "L/mol", each start = 100) "Molar volume of propane";
    Real [3] D (each unit = "%") "Percentage deviation";
    Real a (unit = "L^2 atm / mol^2") "SRK constant 1";
    Real b (unit = "L / mol") "SRK constant 2";
    Real Tr "Reduced pressure of propane";
    Real m;
    Real alpha;
    Real [3] V_cap_ideal (each unit = "L/mol") "Ideal molar volume of propane";
    
    //=============
    // Equation Section 
    equation
        Tr = T/ Tc_p;
        a = 0.42747 * (R * Tc_p)^2 / Pc_p;
        b = 0.08664 * R * Tc_p / Pc_p;
        m = 0.48508 + (1.55171*w_p) - (0.1561*w_p^2);
        alpha = (1+m*(1-Tr^0.5))^2;
        for i in 1:3 loop
            V_cap_ideal[i] = R * T / P[i];
            P[i] = (R*T/(V_cap[i] - b)) - (alpha * a / (V_cap[i]*(V_cap[i] +b))) ; //Evaluates V_cap for different pressures from SRK Equation of State
            V_dot[i] = V_cap[i] * n_dot;
            D[i] = (V_cap_ideal[i] - V_cap[i]) / V_cap[i] * 100; //Deviation calculation
        end for;
        
    
end Ex5_3_3;
//===================================================================