//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-5: Single phase systems
//Example: 5.4-1 Page 206
//Title: Tabulated Compressibility Factors
//===================================================================
model Ex5_4_1
    //=============
    // Parameter Section
    parameter Real T (unit = "K") =  300 "Temperature of methane";
    parameter Real V_dot (unit = "m^3/h") = 50 "Volume of methane";
    parameter Real R (unit = "m^3 Pa/ kmol K") = 8.314 "Gas constant";
    parameter Real P (unit = "bar a") = 40 "Absolute pressure";  
    parameter Real z = 0.934 "Compressibility factor"; //From Pg 2-144 of Perry's Chemical Engineers' Handbook
    parameter Real M (unit = "kg/ kmol")= 16.04 "Molar mass of methane";
    //=============
    // Variable Section
    Real n_dot (unit = "kmol/h") "Molar flow rate of methane";
    Real m_dot (unit = "kg/h") "Mass flow rate of methane";
        
    //=============
    // Equation Section 
    equation
        n_dot = P * V_dot / (R*T*z) * 101.325 / 1.01325; //Converting from bar to kPa
        m_dot = n_dot*M;
        
end Ex5_4_1;
//===================================================================