//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.4-1 Page 255
//Title: Absorption of SO2
//===================================================================
model Ex6_4_1
    //=============
    // Parameter Section
    parameter Real P (unit = "mmHg") = 760 "Pressure of the gas stream";
    parameter Real nG1 (unit = "lbmole/h") = 100 "Inlet molar flow rate of SO2 air mixture";
    parameter Real yG1_SO2 (unit = "lb-mole SO2 /lb-mole") = 0.45 "Inlet molar fraction of SO2";
    parameter Real yG1_air (unit = "lb-mole air /lb-mole") = 0.55 "Inlet molar fraction of air";
    parameter Real XL2_SO2 (unit = "lb SO2 /100 lb H2O") = 2 "Mass ratio of SO2 in leaving liquid";
    parameter Real pH2O (unit = "mmHg") = 31.6 "Partial pressure of H2O at equilibrium over solution"; //From pg 3-65 of 6th Edition of Perry's Chemical Engineers' Handbook"
    parameter Real pSO2 (unit = "mmHg") = 176 "Partial pressure of SO2 at equilibrium over solution"; //From pg 3-65 of 6th Edition of Perry's Chemical Engineers' Handbook"
    
    //=============
    // Variable Section 	
    Real nG2 (unit = "lbmole/h") "Outlet molar flow rate of gas mixture";
    Real nL1 (unit = "lbmole/h") "Intlet molar flow rate of water";
    Real nL2 (unit = "lb/h") "Outlet mass flow rate of liquid stream";
    Real ySO2 (unit = "lb-mole SO2 /lb-mole") "Mole fraction of SO2 in leaving gas mixture";
    Real yair (unit = "lb-mole air/lb-mole") "Mole fraction of air in leaving gas mixture";
    Real yH2O (unit = "lb-mole H2O /lb-mole") "Mole fraction of H2O in leaving gas mixture";
    Real xL2_SO2 (unit = "lb SO2 /lb") "Mass fraction of SO2 in leaving liquid";
    Real f_SO2 (unit = "lb SO2 absorbed / lb SO2 fed") "Fraction of So2 absorbed";
    
    //=============
    // Equation Section 
    equation
        yH2O = pH2O/P;
        ySO2 = pSO2/P;
        yair = 1 - yH2O - ySO2;
        yG1_air * nG1 = yair * nG2; //Air mole balance
        xL2_SO2 = XL2_SO2 / (100 + XL2_SO2); // Converting from mass  ratio to mass fraction
        nG1 * yG1_SO2 = nG2 * ySO2 + (nL2 * xL2_SO2 / 64); //Molar mass of SO2 is 64 lb / lbmol
        nL1 = (nG2 * yH2O * 18) + (nL2 * (1-xL2_SO2)); //H2O Mass balance, 18 lb/lbmol is the molar mass of H2O
        f_SO2 = nL2 * xL2_SO2 / (nG1 * yG1_SO2 *64); 
        
end Ex6_4_1;
//===================================================================