//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.4-2 Page 258
//Title: Raoult's law and Henry's Law
//===================================================================
package Ex6_4_2
    model Ex6_4_2_1
    //=============
    // Parameter Section
    parameter Real yC2H6 = 0.01 "Mole fraction of ethane in gas phase";
    parameter Real P (unit = "atm") = 20 "Pressure of the system";
    parameter Real HC2H6 (unit = "atm /mole fraction") = 2.63e4 "Henry's law constant for ethane water system"; //Taken from Pg 2-126 of Perry's Chemical Engineer's Handbook footnote 1
    
    //=============
    // Variable Section 	
    Real xC2H6 "Mole fraction of ethane in liquid phase";
    
    //=============
    // Equation Section 
    equation
        xC2H6 = yC2H6 * P /HC2H6; //Henry's Law
       
    end Ex6_4_2_1;
    //===================================================================
    
    model Ex6_4_2_2
    //=============
    // Parameter Section
    parameter Real T (unit = "degC") = 30 "Temperature of the system";
    parameter Real xB = 0.5 "Mole fraction of benzene in mixture";
    parameter Real xT = 0.5 "Mole fraction of toluene in mixture";
    
    //=============
    // Variable Section 	
    Real pB_star (unit = "mmHg" ) "Vapor pressure of benzene";
    Real pT_star (unit = "mmHg" ) "Vapor pressure of toluene";
    Real P (unit = "mmHg") "System Pressure";
    Real pT (unit = "mmHg") "Partial pressure of toluene";
    Real pB (unit = "mmHg") "Partial pressure of benzene";
    Real yB (unit = "mole benzene / mole") "Mole fraction of benzene in liquid";
    Real yT (unit = "mole toluene / mole") "Mole fraction of toluene in liquid";
    
    //=============
    // Equation Section 
    equation
        log10(pB_star) = 6.906 - (1211 / (T+220.8)); //From Table B.4
        log10(pT_star) = 6.9533 - (1343.9 / (T + 219.38)); //From Table B.4
        P = pB + pT;
        pB = xB * pB_star;
        pT = xT * pT_star;
        yB = pB/P;
        yT = pT/P;
        
    end Ex6_4_2_2;
    //===================================================================
end Ex6_4_2;
//===================================================================
