//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.5-1 Page 264
//Title: Crystallisation and filtration
//===================================================================
model Ex6_5_1
    //=============
    // Parameter Section
    parameter Real m (unit = "kg") = 150 "Mass of saturated AgNO3 solution fed to crystalliser";
    parameter Real wfc_AgNO3 = 0.80 "Mass percentage of AgNO3 solids in wet filter cake";
    parameter Real wfc_sol = 0.20 "Mass percentage of saturated solution in wet filter cake";
    
    //=============
    // Variable Section 	
    Real m1 (unit = "kg solution") "Mass of saturated solution leaving filter";
    Real m2 (unit = "kg AgNO3 (s)") "Mass of solid AgNO3 crystals from the filter";
    Real m3 (unit = "kg solution") "Mass of AgNO3 solution present in wet filter cake";
    Real m4 (unit = "kg H2O(v)") "Mass of water vapourised in the dryer";
    Real m5 (unit = "kg AgNO3(s)") "Mass of dry AgNO3 crystals formed";
    Real s100 (unit = "kg AgNO3 / kg") "Solubility of AgNO3 at 100 degC";
    Real s20 (unit = "kg AgNO3 / kg") "Solubility of AgNO3 at 20 degC";
    Real pcr (unit = "%") "Percentage recovery of AgNO3";
    
    //=============
    // Equation Section 
    equation
        s100 = 952 / (952+100); //952 kg AgNO3 is the amount of AgNO3 that can dissolve in 100 kg of water, this value is given in pg 264 at the beginning of section 6.2
        s20 = 222 / (222+100); //222 kg AgNO3 is the amount of AgNO3 that can dissolve in 100 kg of water, this value is given in pg 264 at the beginning of section 6.2
        m2 = wfc_AgNO3 * (m2+m3); //Composition of the wet filter cake
        (1-s100)*m = (1-s20) * (m1 + m3); //Water balance over crystalliser and filter
        m = m1 + m2 + m3; //Overall mass balance over crystalliser and filter
        s100*m = s20*m1 + m5; //Overall AgNO3 mass balance
        pcr = m5 / (s100*m) *100;
        m = m1 + m4 + m5; //Overall mass balance
        
end Ex6_5_1;