//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.5-3 Page 267
//Title: Production of a Hydrated Salt
//===================================================================
model Ex6_5_3
    //=============
    // Parameter Section
    parameter Real m (unit = "ton MgSO4.7H2O/h") = 1 "Mass flow rate of KNO3 solution fed to crystalliser";
    parameter Real xf (unit = "ton MgSO4 / ton") = 0.301 "Mass fraction of MgSO4 in feed";
    parameter Real xp (unit = "ton MgSO4 / ton") = 0.232 "Mass fraction of MgSO4 in saturated solution at 10 degC";
        
    //=============
    // Variable Section 	
    Real m1 (unit = "ton/h") "Mass rate of feed solution";
    Real m2 (unit = "ton solution / h") "Mass rate of saturated solution formed";
    
    //=============
    // Equation Section 
    equation
        m1 = m + m2;
        xf * m1 = (m * 120.4 / 246.4) + (m2 * xp); //MgSO4 balance
        //120.4 is molecular wt of MgSO4 and 246.4 is molecular weight of MgSO4.7H2O
        
end Ex6_5_3;