//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-6: Multiphase Systems
//Example: 6.5-4 Page 270
//Title: Colligative property calculations
//===================================================================
model Ex6_5_4
    //=============
    // Parameter Section
    parameter Real m (unit = "g") = 5 "Mass of solute in 100 g of water";
    parameter Real Tbs (unit = "degC") = 100.421 "Boiling point of solution";
    parameter Real Tb0 (unit = "K") = 373.16 "Boiling point of pure water";
    parameter Real R (unit = "J/molK") = 8.314 "Gas constant";
    parameter Real ps_star (unit = "mmHg") = 23.756 "Vapour pressure of water at given conditions"; //From Table B.3
    
    //=============
    // Variable Section 	
    Real x (unit = "mol solute / mol water") "Mole fraction of solute";
    Real delTb (unit = "K") "Elevation in boiling point";
    Real Ms (unit = "g / mol") "Molar weight of solute";
    Real ps_star_e (unit = "mmHg") "Vapour pressure of solution at given conditions";
    Real delTm (unit = "K") "depression in freezing point";
    Real Tms (unit = "degC") "Melting point of the solution";
    
    //=============
    // Equation Section 
    equation
        delTb = R * Tb0^2 * x/ (40656); //40656 J/mol is the latent heat of vapourisation of water, taken from Table B.1
        delTb = (Tbs + 273.16) - Tb0;
        x = (m/Ms) / ((m/Ms) + (100/18));
        ps_star_e = ps_star * (1 - x);
        delTm = R * (273.16^2) * x / 6009.5; //6005.9 J/mol is the latent heat of melting for pure water taken from Table B.1
        Tms = 0 - delTm;
        
end Ex6_5_4;