//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.3-1 Page 319
//Title: Energy Balance on a Closed System
package Ex7_3_1
    //===================================================================
    model Ex7_3_1_1
        //=============
        // Parameter Section
        parameter Real delEk (unit = "J") = 0 "Change in kinetic energy of the system";
        parameter Real delEp (unit = "J") = 0 "Change in potential energy of the system";
        parameter Real W (unit = "J") = 0 "Work done on the system";
        parameter Real Q (unit = "cal") = 2 "Heat transferred to the system";
        
        //=============
        // Variable Section 	
        Real delU (unit = "J") "Change in internal energy of the system";
        
        //=============
        // Equation Section 
        equation
            delU + delEk + delEp = (Q*1e3/0.23901) - W;
            
    end Ex7_3_1_1;
    //===================================================================
    
    model Ex7_3_1_2
        //=============
        // Parameter Section
        parameter Real delEk (unit = "J") = 0 "Change in kinetic energy of the system";
        parameter Real delEp (unit = "J") = 0 "Change in potential energy of the system";
        parameter Real W (unit = "J") = 100 "Work done on the system";
        parameter Real delU (unit = "J") = 0 "Change in internal energy of the system";
            
        //=============
        // Variable Section 	
        Real Q (unit = "J") "Heat transferred to the system";
        
        //=============
        // Equation Section 
        equation
            delU + delEk + delEp = Q - W;
            
    end Ex7_3_1_2;
    //===================================================================
end Ex7_3_1;
