//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.4-2 Page 324
//Title: Energy Balance on a Turbine
//===================================================================
model Ex7_4_2
    //=============
    // Parameter Section
    parameter Real m_dot (unit = "kg/h") = 500 "Mass flow rate of steam";
    parameter Real u1 (unit = "m/s") = 60 "Inlet flow velocity";
    parameter Real u2 (unit = "m/s") = 360 "Outlet flow velocity";
    parameter Real z (unit = "m") = -5 "Change in height of stream";
    parameter Real Ws (unit = "kW") = 70 "Shaft work delivered by turbine";
    parameter Real Q_kcal (unit = "kcal/h") = -1e4 "Heat loss from turbine in kcal/h";
    parameter Real g (unit = "m/s^2") = 9.81 "Acceleration due to gravity";
    
    //=============
    // Variable Section 	
    Real delEk (unit = "kW") "Change in kinetic energy of fluid";
    Real delEp (unit = "kW") "Change in potential energy of fluid";
    Real Q_dot (unit = "kcal/h") "Heat loss from turbine in kW";
    Real delH (unit = "kW") "Enthalphy change in turbine";
    Real delHcap (unit = "kJ/kg") "Specific enthalpy change in turbine";
        
    //=============
    // Equation Section 
    equation
        Q_dot = Q_kcal / 3600 / 0.239e-3 / 1000;
        delEk = m_dot/3600 /2 * (u2^2 - u1^2) / 1e3; //Divding by 1000 to convert to kW
        delEp = m_dot/3600 * g * z / 1000;
        delH = Q_dot - Ws - delEk -delEp;
        delH = delHcap * m_dot/3600;        
        
end Ex7_4_2;