//Richard M. Felder and Ronald W. Rousseau, Elementary Principles of Chemical Processes, 3rd Edition, John Wiley & Sons, Inc. 2000
//Chapter-7: Energy and Energy balances
//Example: 7.5-1 Page 326
//Title: Use of Tabulated Enthalpy data
//===================================================================
package Ex7_5_1
    model Ex7_5_1_2
        //=============
        // Parameter Section
        parameter Real Hcap_0 (unit = "BTU/lb") = 196.23 "Specific enthalpy of Methyl chloride at 0 degF";
        parameter Real Hcap_50 (unit = "BTU/lb") = 202.28 "Specific enthalpy of Methyl chloride at 50 degF";
        parameter Real P_final (unit = "psia") = 18.90 "Pressure of methyl chloride at 0 degF";
        parameter Real P_initial (unit = "psia") = 51.99 "Pressure of methyl chloride at 50 degF";
        parameter Real Vcap_final (unit = "ft^3/lb") = 4.969 "Specific volume of methyl chloride at 0 degF";
        parameter Real Vcap_initial (unit = "ft^3/lb") = 1.920 "Specific volume of methyl chloride at 50 degF";
            
        //=============
        // Variable Section 	
        Real delHcap (unit = "BTU/lb") "Change in specific enthalpy";
        Real delUcap (unit = "BTU/lb") "Change in specific internal energy";
            
        //=============
        // Equation Section 
        equation
            delHcap = Hcap_0 - Hcap_50;
            delUcap = delHcap - (P_final * Vcap_final - P_initial * Vcap_initial) * 1.987 / 10.73;
                    
    end Ex7_5_1_2;
end Ex7_5_1;